#include <iostream>
#include <vector>
#include <map>
#include <algorithm>
#include <numeric>
long long resiUpit(int brojKarata, const std::map<int, int>& brojac, int k)
{
    std::vector<long long> ukupno;
    for (auto const& vrednost : brojac)
    {
        int broj = vrednost.first;
        int ponavljanje = vrednost.second;
        ukupno.push_back((long long)(broj * ponavljanje));
    }
    int razliciti = ukupno.size();
    sort(ukupno.begin(), ukupno.end());
    int mozeDaSeObrise = brojKarata - k;
    int zadrzavam = razliciti - mozeDaSeObrise;
    if (zadrzavam <= 0)
    {
        return 0;
    }
    else
    {
        long long r = 0;
        for (int i = 0; i < zadrzavam;i++)
        {
            r += ukupno[i];
        }
        return r;
    }
}

void f(std::map<int,int>& brojac,int broj, int br)
{
    brojac[broj] += br;
    if (brojac[broj] == 0)
    {
        brojac.erase(broj);
    }
}

int main()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    int brojKarata, brojUpita;
    std::vector<int> karte;
    std::map<int, int> brojac;
    std::cin >> brojKarata >> brojUpita;
    karte.resize(brojKarata + 1);
    for (int i = 1; i <= brojKarata; i++)
    {
        std::cin >> karte[i];
        f(brojac, karte[i], 1);
    }
    while (brojUpita--)
    {
        int t;
        std::cin >> t;
        if (t == 1)
        {
            int k;
            std::cin >> k;
            std::cout << resiUpit(brojKarata, brojac, k) << "\n";
        }
        else
        {
            int x, y;
            std::cin >> x >> y;
            int temp = karte[x];
            karte[x] = y;
            f(brojac, temp, -1);
            f(brojac, y, 1);
        }
    }
    return 0;
}